#region References

using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;

using DAL = gov.va.med.vbecs.DAL;

using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using SProc = gov.va.med.vbecs.Common.VbecsStoredProcs;

#endregion

namespace gov.va.med.vbecs.DAL.HL7AL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Brian    lin</Developer>
	///	<Developer>David Askew</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Patient change hl7 data access object layer class.
	///</summary>

	#endregion

	public class PatientChange
	{
		/// <summary>
		/// Constructor
		/// </summary>
		private PatientChange() {}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8281"> 
		///		<ExpectedInput>DataRow containing a change to an existing patient's Gender.</ExpectedInput>
		///		<ExpectedOutput>Patient.PatientSexCode value changes from either M to F or from F to M.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8282"> 
		///		<ExpectedInput>Null DataRow input parameter.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method updates the 
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		public static bool InsertPatientChange( DataRow dtRow )
		{
			if( dtRow == null )
				throw( new ArgumentNullException( "dtRow" ) );

			SqlParameter[] _prms =
			{
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.PatientChangeGuid, dtRow[ TABLE.PatientChange.PatientChangeGuid ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientGuid, dtRow[ TABLE.PatientChange.FromPatientGuid ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientSsn, dtRow[ TABLE.PatientChange.FromPatientSsn ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromSsnPseudoIndicator, dtRow[ TABLE.PatientChange.FromSsnPseudoIndicator ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientIcn, dtRow[ TABLE.PatientChange.FromPatientIcn ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientLastName, dtRow[ TABLE.PatientChange.FromPatientLastName ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientFirstName, dtRow[ TABLE.PatientChange.FromPatientFirstName ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientMiddleName, dtRow[ TABLE.PatientChange.FromPatientMIddleName ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientDob, dtRow[ TABLE.PatientChange.FromPatientDob ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientDeathDate, dtRow[ TABLE.PatientChange.FromPatientDeathDate ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.FromPatientSexCode, dtRow[ TABLE.PatientChange.FromPatientSexCode ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientGuid, dtRow[ TABLE.PatientChange.ToPatientGuid ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientSsn, dtRow[ TABLE.PatientChange.ToPatientSsn ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToSsnPseudoIndicator, dtRow[ TABLE.PatientChange.ToSsnPseudoIndicator ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientIcn, dtRow[ TABLE.PatientChange.ToPatientIcn ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientLastName, dtRow[ TABLE.PatientChange.ToPatientLastName ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientFirstName, dtRow[ TABLE.PatientChange.ToPatientFirstName ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientMiddleName, dtRow[ TABLE.PatientChange.ToPatientMIddleName ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientDob, dtRow[ TABLE.PatientChange.ToPatientDob ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientDeathDate, dtRow[ TABLE.PatientChange.ToPatientDeathDate ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.ToPatientSexCode, dtRow[ TABLE.PatientChange.ToPatientSexCode ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.MergeFromVistaPatientId, dtRow[ TABLE.PatientChange.MergeFromVistaPatientId ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.MergeToVistaPatientId, dtRow[ TABLE.PatientChange.MergeToVistaPatientId ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.PatientChangeStatusCode, dtRow[ TABLE.PatientChange.PatientChangeStatusCode ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.LastUpdateUser, dtRow[ TABLE.PatientChange.LastUpdateUser ] ),
				Common.StoredProcedure.MakeParameter( SProc.HL7InsertPatientChange.LastUpdateFunctionId, dtRow[ TABLE.PatientChange.LastUpdateFunctionId ] ),

			};

			return (new Common.StoredProcedure().TransactionalGetValue( SProc.HL7InsertPatientChange.StoredProcName, _prms )==0);
		}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8283"> 
		///		<ExpectedInput>No input parameters required.</ExpectedInput>
		///		<ExpectedOutput>Non-null DataTable used to insert data into the PatientChange table.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8284"> 
		///		<ExpectedInput>No failure conditions apply</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method returns a DataTable used to insert data into the PatientChange table.
		/// </summary>
		/// <returns><see cref="DataTable"/> containing required columns for inserting into the PatientChange table.</returns>
		public static DataTable GetPatientChangeDataTable()
		{
			// PatientChange DataTable
			DataTable dtPatientChange = new DataTable();
			//
			dtPatientChange.Columns.Add(TABLE.PatientChange.PatientChangeGuid, typeof(Guid));
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientGuid, typeof(Guid));
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientSsn);
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromSsnPseudoIndicator, typeof(byte));
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientIcn);
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientLastName);
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientFirstName);
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientMIddleName);
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientDob, typeof(DateTime));
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientDeathDate, typeof(DateTime));
			dtPatientChange.Columns.Add(TABLE.PatientChange.FromPatientSexCode);
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientGuid, typeof(Guid));
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientSsn);
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToSsnPseudoIndicator, typeof(byte));
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientIcn);
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientLastName);
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientFirstName);
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientMIddleName);
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientDob, typeof(DateTime));
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientDeathDate, typeof(DateTime));
			dtPatientChange.Columns.Add(TABLE.PatientChange.ToPatientSexCode);
			dtPatientChange.Columns.Add(TABLE.PatientChange.MergeFromVistaPatientId);
			dtPatientChange.Columns.Add(TABLE.PatientChange.MergeToVistaPatientId);
			dtPatientChange.Columns.Add(TABLE.PatientChange.PatientChangeStatusCode);
			dtPatientChange.Columns.Add(TABLE.PatientChange.LastUpdateUser);
			dtPatientChange.Columns.Add(TABLE.PatientChange.LastUpdateFunctionId, typeof(int));
			//
			return dtPatientChange;
		}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/7/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8365"> 
		///		<ExpectedInput>No input parameters required.</ExpectedInput>
		///		<ExpectedOutput>Non-null DataTable used to update data into the Patient table.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8366"> 
		///		<ExpectedInput>No failure conditions apply</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method returns a DataTable used to update the Patient table for a Patient Update event.
		/// </summary>
		/// <returns><see cref="DataTable"/> containing required columns for updating the Patient table.</returns>
		public static DataTable GetPatientUpdateDataTable()
		{
			// Patient DataTable used for Patient Update
			DataTable dtPatient = new DataTable();
			//
			dtPatient.Columns.Add(TABLE.Patient.PatientGuid, typeof(System.Guid));
			dtPatient.Columns.Add(TABLE.Patient.VistaPatientId, typeof(long));	// CR 2431	changed to long to allow for the database change of the VistaPatientId to Bigint
			dtPatient.Columns.Add(TABLE.Patient.PatientSsn, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.SsnPseudoIndicator, typeof(byte));
			dtPatient.Columns.Add(TABLE.Patient.PatientIcn, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.PatientLastName, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.PatientFirstName, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.PatientMiddleName, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.PatientDob, typeof(System.DateTime));
			dtPatient.Columns.Add(TABLE.Patient.PatientDobCode, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.PatientDeathDate, typeof(System.DateTime));
			dtPatient.Columns.Add(TABLE.Patient.PatientSexCode, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.LastUpdateUser, typeof(string));
			dtPatient.Columns.Add(TABLE.Patient.LastUpdateFunctionId, typeof(int));
			//
			return(dtPatient);
		} 

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/16/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9182"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9183"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 2960
		/// </summary>
		public static bool UpdatePatientInformation( ArrayList storedProcedureNames, ArrayList updatedTables )
		{
			if( storedProcedureNames == null )
			{
				throw( new ArgumentNullException( "storedProcedureNames" ) );
			}
			//
			if( updatedTables == null )
			{
				throw( new ArgumentNullException( "updatedTables" ) );
			}
			//
			int sprocCount = storedProcedureNames.Count;
			int tableCount = updatedTables.Count;
			//
			if( sprocCount < 1 || sprocCount > 3 )
			{
				throw( new ArgumentException(string.Concat("Invalid number of stored procedure names in ArrayList: ", sprocCount, " (expecting 1 - 3).")) );
			}
			//
			if( tableCount < 1 || tableCount > 3 )
			{
				throw( new ArgumentException(string.Concat("Invalid number of tables in ArrayList: ", tableCount, " (expecting 1 - 3).")) );
			}
			//
			if( sprocCount != tableCount )
			{
				throw( new ArgumentException(string.Concat("Number of stored procedure names in ArrayList: ", sprocCount, " does not match number of tables in ArrayList: ", tableCount)) );
			}
			//
			return ( new Common.StoredProcedure().TransactionalGetValue(storedProcedureNames, updatedTables) == 0 );
		}

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/16/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9184"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9185"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 2960
		/// CR 2971: removed PatientSsn and PatientIcn parameters
		/// </summary>
		public static bool IsVbecsPatient(long vistaPatientId)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(SProc.HL7IsVbecsPatient.vistapatientid, System.Data.SqlDbType.BigInt)	// CR 2986
			};
			//
			prms[0].Value = vistaPatientId;
			//
			return new Common.StoredProcedure().GetBoolReturnValue( SProc.HL7IsVbecsPatient.StoredProcName, prms );	// CR 2986
		}
	}
}
